# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_USE_PEP517=setuptools
PYTHON_COMPAT=( python3_{12..14} )

inherit distutils-r1

DESCRIPTION="Python implementation of Mimikatz"
HOMEPAGE="https://github.com/skelsec/pypykatz"
#SRC_URI="mirror://pypi/${P:0:1}/${PN}/${P}.tar.gz"
SRC_URI="https://github.com/skelsec/pypykatz/archive/refs/tags/${PV}.tar.gz -> ${P}.gh.tar.gz"

LICENSE="MIT"
SLOT="0"
KEYWORDS="amd64 ~arm64 x86"
RESTRICT="test"

RDEPEND=">=dev-python/unicrypto-0.0.10[${PYTHON_USEDEP}]
	>=dev-python/minidump-0.0.21[${PYTHON_USEDEP}]
	>=dev-python/minikerberos-0.4.1[${PYTHON_USEDEP}]
	>=dev-python/aiowinreg-0.0.10[${PYTHON_USEDEP}]
	>=dev-python/msldap-0.5.7[${PYTHON_USEDEP}]
	>=dev-python/winacl-0.1.7[${PYTHON_USEDEP}]
	>=dev-python/aiosmb-0.4.8[${PYTHON_USEDEP}]
	>=dev-python/aesedb-0.1.4[${PYTHON_USEDEP}]
	dev-python/tqdm[${PYTHON_USEDEP}]
"
DEPEND="${RDEPEND}"
#	test? (
#		dev-python/pytest[${PYTHON_USEDEP}]
#		dev-python/pytest-cov[${PYTHON_USEDEP}]
#	)"

#FAILED tests/test_lsassdecrypt.py
#distutils_enable_tests pytest
#python_test() {
#	./tests/coverage.sh
#}
