// Ripped from https://github.com/Ch0pin/medusa/ and modified to fit Androguard packets

colorLog('[+] LOADING IPC/IPC.JS',{c: Color.Red});

var activity = Java.use('android.app.Activity');
var ContextWrapper = Java.use('android.content.ContextWrapper');


let anActivity = Java.use('android.app.Activity');

anActivity.onCreate.overload('android.os.Bundle').implementation = function(bundle){
    agPacket({component_name: this.getComponentName().getClassName(), activity: this.getCallingActivity()}).send();
    return this.onCreate(bundle);
}


anActivity.onCreate.overload('android.os.Bundle','android.os.PersistableBundle').implementation = function(bundle,persistableBundle){
    agPacket({component_name: this.getComponentName().getClassName(), activity: this.getCallingActivity()}).send();
    return this.onCreate(bundle,persistableBundle);
}

anActivity.setResult.overload('int','android.content.Intent').implementation = function(i, intent){
    agPacket({component_name: this.getComponentName().getClassName(), i: i, intent: dumpIntent(intent)}).send();
    return this.setResult(i, intent);
}

anActivity.setResult.overload('int').implementation = function(i){
    agPacket({component_name: this.getComponentName().getClassName(), i: i}).send();
    return this.setResult(i,intent);
}

activity.startActivity.overload('android.content.Intent').implementation = function(intent){
    agPacket({intent: dumpIntent(intent)}).send();
    return this.startActivity(intent);

}
activity.startActivity.overload('android.content.Intent','android.os.Bundle').implementation = function(intent, bundle){
    agPacket({intent: dumpIntent(intent)}).send();
    return this.startActivity(intent,bundle);

}
activity.startActivityForResult.overload('android.content.Intent','int').implementation = function(intent,requestCode){
    agPacket({intent: dumpIntent(intent), requestCode: requestCode}).send();
    return this.startActivityForResult(intent,requestCode);
}

// Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#sendBroadcast(android.content.Intent)
ContextWrapper.sendBroadcast.overload("android.content.Intent").implementation = function(intent) {
    agPacket({intent: dumpIntent(intent), requestCode: requestCode}).send();
    return this.sendBroadcast.overload("android.content.Intent").apply(this, arguments);
};

// Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#sendBroadcast(android.content.Intent, java.lang.String)
ContextWrapper.sendBroadcast.overload("android.content.Intent", "java.lang.String").implementation = function(intent, receiverPermission) {
    agPacket({intent: dumpIntent(intent)}).send();
    return this.sendBroadcast.overload("android.content.Intent", "java.lang.String").apply(this, arguments);
};



ContextWrapper.sendStickyBroadcast.overload("android.content.Intent").implementation = function(intent) {
    agPacket({intent: dumpIntent(intent)}).send();
    return this.sendStickyBroadcast.overload("android.content.Intent").apply(this, arguments);
};


//Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#startService(android.content.Intent)
ContextWrapper.startService.implementation = function(service) {
    agPacket({service: dumpIntent(service)}).send();
    return this.startService.apply(this, arguments);
};



//Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#stopService(android.content.Intent)
ContextWrapper.stopService.implementation = function(name) {
    agPacket({service: dumpIntent(service)}).send();
    return this.stopService.apply(this, arguments);
};

//Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#registerReceiver(android.content.BroadcastReceiver, android.content.IntentFilter)
ContextWrapper.registerReceiver.overload("android.content.BroadcastReceiver", "android.content.IntentFilter").implementation = function(receiver, filter) {
    agPacket({receiver: dumpReceiver(receiver), filter: dumpFilter(filter)}).send();
    return this.registerReceiver.apply(this, arguments);
};

// Ref: https://developer.android.com/reference/android/content/Context#registerReceiver(android.content.BroadcastReceiver,%20android.content.IntentFilter,%20int)
ContextWrapper.registerReceiver.overload("android.content.BroadcastReceiver", "android.content.IntentFilter", "int").implementation = function(receiver, filter, flags) {
    agPacket({receiver: dumpReceiver(receiver), filter: dumpFilter(filter), flags: flags}).send();
    return this.registerReceiver.apply(this, arguments);
};

//Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#registerReceiver(android.content.BroadcastReceiver, android.content.IntentFilter, java.lang.String, android.os.Handler)
ContextWrapper.registerReceiver.overload("android.content.BroadcastReceiver", "android.content.IntentFilter", "java.lang.String", "android.os.Handler").implementation = function(receiver, filter, broadcastPermission, scheduler) {
    agPacket({receiver: dumpReceiver(receiver), filter: dumpFilter(filter), broadcastPermission: broadcastPermission}).send();
    return this.registerReceiver.apply(this, arguments);
};

//Ref: https://developer.android.com/reference/android/content/ContextWrapper.html#registerReceiver(android.content.BroadcastReceiver,%20android.content.IntentFilter,%20java.lang.String,%20android.os.Handler,%20int)
ContextWrapper.registerReceiver.overload("android.content.BroadcastReceiver", "android.content.IntentFilter", "java.lang.String", "android.os.Handler", "int").implementation = function(receiver, filter, broadcastPermission, scheduler, flags) {
    agPacket({receiver: dumpReceiver(receiver), filter: dumpFilter(filter), broadcastPermission: broadcastPermission, flags: flags}).send();
    return this.registerReceiver.apply(this, arguments);
};