![banner](https://raw.githubusercontent.com/androguard/androguard/master/assets/web/androguardwithname.jpg)

# Androguard

[![PyPI Upload](https://github.com/androguard/androguard/actions/workflows/pythonpublish.yml/badge.svg)](https://github.com/androguard/androguard/actions/workflows/pythonpublish.yml)
![PyPI - Version](https://img.shields.io/pypi/v/androguard)
![Static Badge](https://img.shields.io/badge/Documentation-InProgress-red)

New tool: Goauld [Dynamic injection tool for Linux/Android ](https://github.com/androguard/goauld)

## Installation
Quick installation:
~~~~
pip install androguard
~~~~

> [!IMPORTANT]
> Versions >= 4.0.0 are new releases after a long time, where the project has substantial differences from the previous stable version 3.3.5 from 2019. This means that certain functionalities have been removed. If you notice an issue with your project using the latest version, please open up an [issue](https://github.com/androguard/androguard/issues).

## Documentation
**Documentation contains outdated information - In progress of updating**

The [Github Pages Documentation](http://androguard.github.io/androguard/) is the most up to date source.

Additional documentation that contains outdated information is available at [ReadTheDocs](http://androguard.readthedocs.io/en/latest/).


## Features

Androguard is a full python tool to play with Android files.

* DEX, ODEX
* APK
* Android's binary xml
* Android resources
* Disassemble DEX/ODEX bytecodes
* Basic Decompiler for DEX/ODEX files
* Frida support for easy dynamic analysis
* SQLite database to save the session

## Authors: Androguard Team

Androguard + tools: Anthony Desnos (desnos at t0t0.fr).

DAD (DAD is A Decompiler): Geoffroy Gueguen (geoffroy dot gueguen at gmail dot com)

## Projects using Androguard
In alphabetical order

* [AndroPyTool](https://github.com/alexMyG/AndroPyTool)
* [AppKnox](http://appknox.com)
* [Cuckoo Sandbox](https://cuckoosandbox.org)
* [Deckard](https://github.com/hrkfdn/deckard)
* [Droidbot](https://github.com/honeynet/droidbot)
* [Droidstatx](https://github.com/integrity-sa/droidstatx)
* [εxodus](https://github.com/Exodus-Privacy/exodus)
* [F-Droid Server](https://gitlab.com/fdroid/fdroidserver)
* [gplaycli](https://github.com/matlink/gplaycli)
* [Koodous](https://koodous.com)
* [MobSF](https://github.com/MobSF/Mobile-Security-Framework-MobSF)
* [qiew](https://github.com/mtivadar/qiew)
* [Quark-Engine](https://github.com/quark-engine/quark-engine)
* [Virustotal](https://virustotal.readme.io/reference/androguard)
* [Viper Framework](https://github.com/viper-framework/viper)
* ... and many more!

You are using Androguard and are not listed here? Just create a [ticket](https://github.com/androguard/androguard/issues) or send us a [pull request](https://github.com/androguard/androguard/pulls) with your project!

## Licenses

### Androguard

Copyright (C) 2012 - 2024, Anthony Desnos (desnos at t0t0.fr)
All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS-IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

### DAD

Copyright (C) 2012 - 2016, Geoffroy Gueguen (geoffroy dot gueguen at gmail dot com)
All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS-IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
