#!/bin/sh
# @(#) $Id: update-ethercodes.sh.in 1547 2025-03-02 18:00:03Z leres $ (LBL)
#
#  Generate ethercodes.dat
#

prog="`basename $0`"

t1=/tmp/${prog}.1.$$

trap 'rm -f ${t1}; exit 1' 1 2 3 15 EXIT

if [ ! -f arp.dat ]; then
	cd /usr/share/arpwatch || exit 1
fi

fn=ethercodes.dat
url=https://standards-oui.ieee.org/oui/oui.csv

cmd1="curl --no-progress-meter ${url}"
cmd2=/usr/sbin/massagevendor.py

# Emit exit status of first command in pipe
# https://unix.stackexchange.com/a/70675
((((${cmd1}; echo $? >&3) | ${cmd2} >&4) 3>&1) | (read xs; exit ${xs})) 4> ${t1}
if [ $? -ne 0 ]; then
	rm -f ${t1}
	exit 1
fi

if [ ! -e ${fn} ]; then
	mv ${t1} ${fn} || exit 1
	exit
fi
diff ${t1} ${fn} > /dev/null
if [ $? -eq 1 ]; then
	mv ${t1} ${fn} || exit 1
fi
