INSTGRP 	?= "root"
MANGRP 		?= "@mangrp@"
INSTUSR 	?= "root"

BLDHOME		= .

CXX		= x86_64-pc-linux-gnu-g++ -std=gnu++20
CC		= x86_64-pc-linux-gnu-gcc
LD		= x86_64-pc-linux-gnu-g++ -std=gnu++20
CCLD		= x86_64-pc-linux-gnu-gcc

# Set a number of warnings to silent; some of our dependent libraries (asio) and generated code (protobuf)
# make current gcc/clang awful cranky under -wall

LDFLAGS		+= -Wl,-O1 -Wl,--as-needed -Wl,-z,pack-relative-relocs -Wl,--defsym=__gentoo_check_ldflags__=0
CFLAGS		+= -Wall -Wno-format-truncation -Wno-unused-function -g -I. -fPIE -I/usr/include/libnm -I/usr/lib64/libffi/include -pthread -I/usr/include/glib-2.0 -I/usr/lib64/glib-2.0/include -I/usr/include/libmount -I/usr/include/blkid -I/usr/include/libnl3 -Wno-dangling-reference -pthread -I/usr/include/dbus-1.0 -I/usr/lib64/dbus-1.0/include -I/usr/include/elogind 
CXXFLAGS 	+= -Wall -Wno-deprecated-declarations -Wno-format-truncation -Wno-unused-local-typedefs -Wno-unused-function -Wno-infinite-recursion -g -I. -fPIE  -mtune=core2 -pipe -frecord-gcc-switches  -DKS_STR_ENCODING_NONE -I/usr/include/dbus-1.0 -I/usr/lib64/dbus-1.0/include -I/usr/include/elogind 
CPPFLAGS 	+= -Wno-dangling-reference

INSTALL		= /usr/lib/portage/python3.13/ebuild-helpers/xattr/install -c
INSTALL_DATA = ${INSTALL} -m 644
INSTALL_PROGRAM = ${INSTALL}
INSTALL_SCRIPT = ${INSTALL}
INSTALL_STRIP_PROGRAM = @INSTALL_STRIP_PROGRAM@

CXXLIBS 	+=  -lstdc++

LIBS		+= -lcap  -ldw -ldl -lz -latomic -lpcre2-8 -lsqlite3 -lsensors
KSLIBS		+=  -lpthread   -lssl -lcrypto

PTHREAD_LIBS = -lpthread
CAPLIBS		= -lcap -lwebsockets -lcap
NETLINKLIBS	= -lnl-genl-3 -lnl-3
AIRCAPLIBS	= @airpcaplib@

PROTOLIBS 	= 
PROTOCFLAGS	= 
PROTOCBIN 	?= 

PTHREADCFLAGS = -pthread
NMFLAGS		= -I/usr/include/libnm -I/usr/lib64/libffi/include -pthread -I/usr/include/glib-2.0 -I/usr/lib64/glib-2.0/include -I/usr/include/libmount -I/usr/include/blkid
NMLIBS		= -lnm -lgio-2.0 -lgobject-2.0 -lglib-2.0

PCAPLIBS	= -lpcap

LIBMLIB		= -lm

LIBUBERTOOTHLIBS = -lubertooth
LIBUBERTOOTHCFLAGS = 

LIBBTBBLIBS = -lbtbb
LIBBTBBCFLAGS = 

LIBUSBLIBS = -lusb-1.0
LIBUSBCFLAGS = -I/usr/include/libusb-1.0

LIBRTLLIBS = -lrtlsdr
LIBRTLCFLAGS = -I/usr/include/

LIBWSLIBS = -lwebsockets -lcap
LIBWSCFLAGS = 

SUIDGROUP 	= kismet

DATASOURCE_LIBS	+= $(CAPLIBS) $(PTHREAD_LIBS) -lm

PYTHON		?= python3


prefix 		= /usr
exec_prefix = ${prefix}
plugindir	= /usr/lib64/kismet
ETC			= ${DESTDIR}/etc/kismet
BIN			= ${DESTDIR}${exec_prefix}/bin
SHARE 		= ${DESTDIR}/usr/share/kismet/
MAN 		= ${DESTDIR}/usr/share/man
LIB			= ${DESTDIR}/usr/lib64
WAV 		= ${DESTDIR}/usr/share/kismet/wav/
HTTPD		= ${DESTDIR}/usr/share/kismet/httpd/

PLUGINLDFLAGS +=  -Wl,-O1 -Wl,--as-needed -Wl,-z,pack-relative-relocs -Wl,--defsym=__gentoo_check_ldflags__=0

GIT			?= git

